<?php
include "config.php";
include "functions.php";

// ── Read incoming update ──────────────────────────────────────────
$input  = file_get_contents("php://input");
$update = json_decode($input, true);

if (!$update) {
    exit; // Not a valid update
}

// ═══════════════════════════════════════════════════════════════════
//  CALLBACK QUERY  (user pressed inline button)
// ═══════════════════════════════════════════════════════════════════

if (isset($update['callback_query'])) {

    $cb       = $update['callback_query'];
    $chat_id  = $cb['message']['chat']['id'];
    $cb_data  = $cb['data'];
    $cb_id    = $cb['id'];

    answerCallback($cb_id);

    if ($cb_data === "buy") {

        // Unique order ID
        $order = "ORDER" . time() . rand(100, 999);

        $safe_chat  = mysqli_real_escape_string($conn, $chat_id);
        $safe_order = mysqli_real_escape_string($conn, $order);

        // ✅ Save user + order to DB before hitting payment API
        mysqli_query($conn,
            "INSERT INTO users (telegram_id, order_id, status)
             VALUES ('$safe_chat', '$safe_order', 'pending')
             ON DUPLICATE KEY UPDATE order_id='$safe_order', status='pending'"
        );

        if (mysqli_error($conn)) {
            error_log("[TheDark Bot] DB insert error: " . mysqli_error($conn));
        }

        sendMessage($chat_id,
            "⏳ <b>Generating your payment link...</b>\n\n" .
            "Please wait a moment."
        );

        // Call payment creator
        $ch = curl_init("https://membership.thedark.pro/create_payment.php?user=$safe_chat&order=$safe_order");
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 20,
        ]);
        curl_exec($ch);
        curl_close($ch);
    }

    exit;
}

// ═══════════════════════════════════════════════════════════════════
//  MESSAGE  (user sent text)
// ═══════════════════════════════════════════════════════════════════

if (isset($update['message'])) {

    $msg     = $update['message'];
    $chat_id = $msg['chat']['id'];
    $text    = $msg['text']               ?? '';
    $name    = $msg['chat']['first_name'] ?? 'User';

    // ── /start ────────────────────────────────────────────────────
    if ($text === "/start") {

        $welcome =
            "👋 Welcome, <b>" . htmlspecialchars($name, ENT_QUOTES) . "</b>!\n\n" .
            "💎 <b>Premium Channel Access</b>\n\n" .
            "💰 Price    : ₹2500\n" .
            "📅 Duration : 30 Days\n" .
            "✅ Instant access after payment\n\n" .
            "Press the button below to purchase your membership.";

        $keyboard = [
            "inline_keyboard" => [[
                ["text" => "💳 Pay ₹2500", "callback_data" => "buy"]
            ]]
        ];

        sendMessage($chat_id, $welcome, $keyboard);
    }

    // ── /status ───────────────────────────────────────────────────
    elseif ($text === "/status") {

        $safe = mysqli_real_escape_string($conn, $chat_id);
        $q    = mysqli_query($conn, "SELECT * FROM users WHERE telegram_id='$safe'");
        $user = mysqli_fetch_assoc($q);

        if ($user && $user['status'] === 'active') {
            sendMessage($chat_id,
                "✅ <b>Membership Active</b>\n\n" .
                "📅 Expires: <code>" . $user['expire_date'] . "</code>"
            );
        } else {
            $keyboard = [
                "inline_keyboard" => [[
                    ["text" => "💳 Buy Membership", "callback_data" => "buy"]
                ]]
            ];
            sendMessage($chat_id,
                "❌ <b>No active membership found.</b>\n\n" .
                "Press below to purchase.",
                $keyboard
            );
        }
    }

    exit;
}
?>
