<?php
include "config.php";
include "functions.php";

$rawInput = file_get_contents("php://input");
$data     = json_decode($rawInput, true);

// ── Validate payload ──────────────────────────────────────────────
if (!$data) {
    http_response_code(400);
    exit("INVALID PAYLOAD");
}

foreach (['order_sn', 'amount', 'status', 'sign', 'merchant_order_id'] as $field) {
    if (!isset($data[$field])) {
        http_response_code(400);
        exit("MISSING: $field");
    }
}

// ── Verify signature ──────────────────────────────────────────────
$expected = strtoupper(md5(
    $data['order_sn'] .
    $data['amount']   .
    $data['status']   .
    API_SECRET
));

if (!hash_equals($expected, strtoupper($data['sign']))) {
    http_response_code(403);
    error_log("[TheDark Bot] Callback INVALID SIGN | raw: $rawInput");
    exit("INVALID SIGN");
}

// ── Only process SUCCESS ──────────────────────────────────────────
if ($data['status'] === "SUCCESS") {

    $order = mysqli_real_escape_string($conn, $data['merchant_order_id']);

    // Find user by order_id
    $q    = mysqli_query($conn, "SELECT * FROM users WHERE order_id='$order'");
    $user = mysqli_fetch_assoc($q);

    if (!$user) {
        error_log("[TheDark Bot] Callback: No user found for order $order");
        echo "OK";
        exit;
    }

    // ── Prevent duplicate processing ─────────────────────────────
    if ($user['status'] === 'active') {
        echo "OK";
        exit;
    }

    $uid    = $user['telegram_id'];
    $expire = date("Y-m-d H:i:s", strtotime("+30 days"));

    // ── Activate membership ───────────────────────────────────────
    mysqli_query($conn,
        "UPDATE users SET status='active', expire_date='$expire' WHERE order_id='$order'"
    );

    if (mysqli_error($conn)) {
        error_log("[TheDark Bot] DB update error: " . mysqli_error($conn));
    }

    // ── Generate one-time invite link ─────────────────────────────
    $link = createInvite();

    if ($link) {
        $keyboard = [
            "inline_keyboard" => [[
                ["text" => "🔗 Join Channel", "url" => $link]
            ]]
        ];
        sendAnimation($uid);
        sendMessage($uid,
            "✅ <b>Payment Successful!</b>\n\n" .
            "🎟 <b>Your Channel Join Link:</b>\n" .
            "<code>$link</code>\n\n" .
            "⚠️ Valid for <b>1 use only</b> — do not share.\n" .
            "📅 Membership expires: <code>$expire</code>",
            $keyboard
        );
    } else {
        sendMessage($uid,
            "✅ <b>Payment received!</b>\n\n" .
            "⚠️ Could not auto-generate invite link.\n" .
            "Please contact support and share your Order ID:\n" .
            "<code>$order</code>"
        );
    }
}

echo "OK";
?>
